<?php
/*--------------------------------------------------------------
   GambioWidgetDefinition.php 2021-08-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Options;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Titles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Author;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Icon;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Type;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Version;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Visualization;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

abstract class GambioWidgetDefinition implements WidgetDefinition
{
    protected const LANGUAGE_CODE_GERMAN = 'de';
    
    protected const LANGUAGE_CODE_ENGLISH = 'en';
    
    protected const LANGUAGE_ID_GERMAN = 2;
    
    protected const QUERY_TIMESPAN_FORMAT_DATE_START = 'Y-m-d 00:00:00';
    
    protected const QUERY_TIMESPAN_FORMAT_DATE_END = 'Y-m-d 23:59:59';
    
    protected const EXCLUDED_ORDER_STATUS_IDS = [99];
    
    /**
     * @var Type
     */
    protected $type;
    
    /**
     * @var Version
     */
    protected $version;
    
    /**
     * @var Author
     */
    protected $author;
    
    /**
     * @var Icon
     */
    protected $icon;
    
    /**
     * @var Visualization
     */
    protected $visualization;
    
    /**
     * @var Options
     */
    protected $options;
    
    /**
     * @var Titles
     */
    protected $titles;
    
    
    /**
     * Constructor.
     */
    public function __construct(
        Type $type,
        Version $version,
        Icon $icon,
        Visualization $visualization,
        Options $options,
        Titles $titles
    ) {
        $this->type          = $type;
        $this->version       = $version;
        $this->author        = Author::create('Gambio GmbH');
        $this->icon          = $icon;
        $this->visualization = $visualization;
        $this->options       = $options;
        $this->titles        = $titles;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): Type
    {
        return $this->type;
    }
    
    
    /**
     * @inheritDoc
     */
    public function version(): Version
    {
        return $this->version;
    }
    
    
    /**
     * @inheritDoc
     */
    public function author(): Author
    {
        return $this->author;
    }
    
    
    /**
     * @inheritDoc
     */
    public function icon(): Icon
    {
        return $this->icon;
    }
    
    
    /**
     * @inheritDoc
     */
    public function titles(): Titles
    {
        return $this->titles;
    }
    
    
    /**
     * @inheritDoc
     */
    public function visualization(): Visualization
    {
        return $this->visualization;
    }
    
    
    /**
     * @inheritDoc
     */
    public function options(): Options
    {
        return $this->options;
    }
    
    
    /**
     * @inheritDoc
     */
    abstract public function data(Options $options): Data;
}